/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/    

/**
 * \file    spiFlash_test.c
 *
 * \brief   Support routines for testing SPI-NAND Flash on EVM
 *
 * This file contains the Support routines for testing SPI-NAND Flash on EVM.
 *
 * \author  0043
 *
 * \version 01a,13sep,2010 Created
 */

/*
 *====================
 * Includes
 *====================
 */
#include "stdio.h"
#include "DM814x_EVM.h"
#include "spiflash.h"

/*
 *====================
 * Satic declarations
 *====================
 */
static UINT8 tx[SPIFLASH_PAGESIZE];
static UINT8 rx[SPIFLASH_PAGESIZE];

/*
 *====================
 * Function implementation
 *====================
 */
 /** **************************************************************************
 * \n \brief Routine to test the the Spiflash device
 *
 * This routine tests the Spiflash device by writing a page of data and 
 * reading the same .Then compares both if comparison is success it returns 
 * success.
 * 
 * \param  power_cycle_test   [IN]  Testid
 *
 * \return
 *
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 *
 */
STATUS spiflash_test(INT16 power_cycle_test)
{
	STATUS u32RetVal = SUCCESS;
    INT16 i, j;
    UINT8* p8;

    /* Initialize the SPI interface */
    spiflash_init( );
	
#if 0	
	u32RetVal = spiFlash_readID ();

	if (SUCCESS != u32RetVal )
	{
		printf ("Unable to read the correct Device ID/Manuf ID.\r\n");
		return (u32RetVal);
	}
#endif

    /* Write to spiflash */
    for ( i = 0 ; i < 1 ; i++ )
    {
        /* Create the test pattern */
        p8 = ( UINT8* )tx;
        for ( j = 0 ; j < SPIFLASH_PAGESIZE ; j++ )
            *p8++ = ( UINT8 )( j + i );

        if (!power_cycle_test)
	{
	    /* Write a page */
	    spiflash_write( ( UINT32 )tx, i * SPIFLASH_PAGESIZE, SPIFLASH_PAGESIZE );
	}
    }

    /* Clear receive buffer */
    for ( j = 0 ; j < SPIFLASH_PAGESIZE ; j++ )
        rx[j] = 0;

    /* Read and verify spiflash */
    for ( i = 0 ; i < 1 ; i++ )
    {
        /* Read a page */
        spiflash_read( i * SPIFLASH_PAGESIZE, ( UINT32 )rx, SPIFLASH_PAGESIZE );

        /* Check the pattern */
        p8 = ( UINT8* )rx;
        for ( j = 0 ; j < SPIFLASH_PAGESIZE ; j++ )
        {
        	/* Compare the data read against the expected */
            if ( ( *p8++ ) != ( UINT8 )( i + j ) )
            {
            	u32RetVal = FAILED;
            	printf ("Data comparision failed.\r\n");
                return (u32RetVal);  // Fail
            }
        }
    }

    return (u32RetVal);
}

